#ifndef __EPL_APPLICATION_H
#define __EPL_APPLICATION_H

#include "TLR_Types.h"
#include "TLR_Packet.h"

#include "Application.h"

#include "Pls_Public.h"
#include "Od2_Public.h"


#include <malloc.h>

#ifdef __cplusplus
  extern "C" {
#endif  /* _cplusplus */


/* the size of the real-time-data in byte*/
#define MAX_RTD_SIZE 4


/*************************************************************************************************
 * @brief This structure contains all bus specific specific application data.
 *
 */
typedef struct EPL_APPLICATION_DATA_Ttag
{
  /* Powerlink needs no special application data,
   * so we just leave this structure empty.
   */
} EPL_APPLICATION_DATA_T;



/*************************************************************************************************
 * @brief This structure contains all application data.
 * It combines the common application data and the bus specific application data.
 */
typedef struct EPL_APPLICATION_Ttag
{
  APPLICATION_COMMON_T tCommon;
  EPL_APPLICATION_DATA_T tData;
} EPL_APPLICATION_T;


/***************************************************************************************/

#ifdef __cplusplus
  }
#endif  /* _cplusplus */


#endif /* #ifndef __EPL_APPLICATION_H */
